<?php
// app/Http/Controllers/Auth/LoginController.php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    use AuthenticatesUsers;

    protected $redirectTo = RouteServiceProvider::HOME;

    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    // Override para usar DNI en lugar de email
    public function username()
    {
        return 'dni';
    }

    // Override del método de login
    protected function validateLogin(Request $request)
    {
        $request->validate([
            $this->username() => 'required|string',
            'password' => 'required|string',
        ], [
            'dni.required' => 'El DNI es obligatorio.',
            'password.required' => 'La contraseña es obligatoria.',
        ]);
    }

    // Redirección después del login basada en roles
    protected function redirectTo()
    {
        $user = Auth::user();

        if ($user->hasRole('administrador')) {
            return '/admin/dashboard';
        } elseif ($user->hasRole('proveedor')) {
            return '/proveedor/dashboard';
        } elseif ($user->hasRole('operador')) {
            return '/operador/dashboard';
        }

        return '/home';
    }
}
